<?php
/*--------------------------------------------------------------------
 gm_get_conf.inc.php 2020-04-21
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------------*/

use Doctrine\DBAL\DBALException;
use Doctrine\DBAL\DriverManager;
use Gambio\Core\Configuration\Compatibility\ConfigurationCompatibilityService;

/**
 * Fetches configuration values by the given key.
 * Returns null if no configuration item was found by provided key.
 *
 * @param string|array $gm_key        Key of configuration to be fetched.
 * @param string       $result_type   Either "ASSOC" or "NUMERIC".
 * @param bool         $p_renew_cache True if unavailable items should be queried.
 *
 * @return array|string|null Array if $gm_key is an array too, string otherwise and null if nothing was found only.
 * @throws DBALException
 * @deprecated This method shouldn't be used for new domains and exist for compatibility purposes.
 */
function gm_get_conf($gm_key, $result_type = 'ASSOC', $p_renew_cache = false)
{
    /** @var ConfigurationCompatibilityService $service */
    static $service;
    if (null === $service) {
        $dbHost = DB_SERVER;
        $dbUser = DB_SERVER_USERNAME;
        $dbName = DB_DATABASE;
        $dbPass = DB_SERVER_PASSWORD;
        $dbPass = $dbPass === '' ? '' : ':' . urlencode($dbPass);
        
        $dsn        = "pdo-mysql://$dbUser$dbPass@$dbHost/$dbName?charset=UTF8";
        $connection = DriverManager::getConnection(['url' => $dsn]);
        
        $service = new ConfigurationCompatibilityService($connection);
    }
    
    return $service->gmGetConf($gm_key, $result_type, $p_renew_cache);
}
